/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.client.BookBakedModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class BookLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();
    private static final TypeToken<Map<String, String>> MACROS_TOKEN = new TypeToken<Map<String, String>>(){};
    private static final class_7654 BOOK_FINDER = class_7654.method_45114((String)"lavender/books");
    private static final Map<class_2960, Book> LOADED_BOOKS = new HashMap<class_2960, Book>();
    private static final Map<class_2960, Book> VISIBLE_BOOKS = new HashMap<class_2960, Book>();

    public static void initialize() {
        ModelLoadingPlugin.register(context -> {
            context.addModels(new class_2960[]{BookBakedModel.Unbaked.BROWN_BOOK_ID});
            for (Book book : VISIBLE_BOOKS.values()) {
                if (book.dynamicBookModel() == null) {
                    return;
                }
                context.addModels(new class_2960[]{new class_1091(book.dynamicBookModel(), "inventory")});
            }
        });
    }

    @Nullable
    public static Book get(class_2960 bookId) {
        return LOADED_BOOKS.get(bookId);
    }

    public static Collection<Book> loadedBooks() {
        return Collections.unmodifiableCollection(VISIBLE_BOOKS.values());
    }

    static Collection<Book> allBooks() {
        return Collections.unmodifiableCollection(LOADED_BOOKS.values());
    }

    public static void reload(class_3300 manager) {
        LOADED_BOOKS.clear();
        BOOK_FINDER.method_45113(manager).forEach((identifier, resource) -> {
            JsonElement jsonElement;
            try (BufferedReader reader = resource.method_43039();){
                jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
            }
            catch (IOException e) {
                Lavender.LOGGER.warn("Could not load book '{}'", identifier, (Object)e);
                return;
            }
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject bookObject = jsonElement.getAsJsonObject();
            class_2960 resourceId = BOOK_FINDER.method_45115(identifier);
            String texture = class_3518.method_15253((JsonObject)bookObject, (String)"texture", null);
            class_2960 textureId = texture != null ? class_2960.method_12829((String)texture) : null;
            String extend = class_3518.method_15253((JsonObject)bookObject, (String)"extend", null);
            class_2960 extendId = extend != null ? class_2960.method_12829((String)extend) : null;
            String dynamicBookModel = class_3518.method_15253((JsonObject)bookObject, (String)"dynamic_book_model", null);
            class_2960 dynamicBookModelId = dynamicBookModel != null ? class_2960.method_12829((String)dynamicBookModel) : null;
            String introEntry = class_3518.method_15253((JsonObject)bookObject, (String)"intro_entry", null);
            class_2960 introEntryId = introEntry != null ? class_2960.method_12829((String)introEntry) : null;
            boolean displayCompletion = class_3518.method_15258((JsonObject)bookObject, (String)"display_completion", (boolean)false);
            Map macros = (Map)GSON.fromJson((JsonElement)class_3518.method_15281((JsonObject)bookObject, (String)"macros", (JsonObject)new JsonObject()), MACROS_TOKEN);
            Book book = new Book(resourceId, extendId, textureId, dynamicBookModelId, introEntryId, displayCompletion, macros);
            LOADED_BOOKS.put(resourceId, book);
            if (extendId == null) {
                VISIBLE_BOOKS.put(resourceId, book);
            }
        });
        LOADED_BOOKS.values().removeIf(book -> {
            if (book.tryResolveExtension()) {
                return false;
            }
            Lavender.LOGGER.warn("Book '" + book.id() + "' (an extension) failed to load because its target was not found");
            return true;
        });
    }
}

